-- USERID = 190
--USE [V5_Registry] 

/******************************************************************************************
* STD_REGISTRY CREATION: This section creates the roles needed for MSSR
* 
*   -- CREATE REGISTRY FOR MSSR (REGISTRY ID = 6) (could differ in other environments)
*******************************************************************************************/
SET IDENTITY_INSERT [dbo].[STD_REGISTRY] ON

INSERT INTO [V5_Registry].[dbo].[STD_REGISTRY] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED]) 
VALUES (6, 'MSSR', 'MSSR Registry', 'Multiple Sclerosis Surveillance Registry', 6, 0, NULL, 'vhamocryank', GETDATE(), 'vhamocryank', GETDATE());

SET IDENTITY_INSERT [dbo].[STD_REGISTRY] OFF
GO


/*********************************************************************
* STD_ROLE CREATION: This section creates the roles needed for MSSR
* 
*   -- CREATE ROLES FOR MSSR (REGISTRY ID = 6)
**********************************************************************/
-- ADMIN - SUPER USER
IF (SELECT COUNT(*) FROM [dbo].[STD_ROLE] WHERE ID = 407) = 0
BEGIN

SET IDENTITY_INSERT [dbo].[STD_ROLE] ON

INSERT INTO [V5_Registry].[dbo].[STD_ROLE] (ID, CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, INACTIVE_FLAG, INACTIVE_DATE, CREATEDBY, UPDATEDBY, CREATED, UPDATED, PARENT_ROLE_ID, STD_REGISTRY_ID, SUPER_USER_FLAG)
VALUES (407, 'MSSR_SYSTEM_ADMINISTRATOR', 'MSSR SYSTEM ADMINISTRATOR', 'MSSR SYSTEM ADMINISTRATOR: Super User', 1, 0, NULL, 'vhamocryank', 'vhamocryank', GETDATE(), GETDATE(), NULL, 6, 1);

-- MSSR_NATIONAL
INSERT INTO [V5_Registry].[dbo].[STD_ROLE] (ID, CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, INACTIVE_FLAG, INACTIVE_DATE, CREATEDBY, UPDATEDBY, CREATED, UPDATED, PARENT_ROLE_ID, STD_REGISTRY_ID, SUPER_USER_FLAG)
VALUES (408, 'MSSR_NATIONAL', 'MSSR NATIONAL', 'MSSR NATIONAL: Edit/Read access to national data but no admin rights', 2, 0, NULL, 'vhamocryank', 'vhamocryank',  GETDATE(), GETDATE(), NULL, 6, 0);

-- MSSR_LOCAL_ADMINISTRATOR
INSERT INTO [V5_Registry].[dbo].[STD_ROLE] (ID, CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, INACTIVE_FLAG, INACTIVE_DATE, CREATEDBY, UPDATEDBY, CREATED, UPDATED, PARENT_ROLE_ID, STD_REGISTRY_ID, SUPER_USER_FLAG)
VALUES (409, 'MSSR_LOCAL_ADMINISTRATOR', 'MSSR LOCAL ADMINISTRATOR', 'MSSR LOCAL ADMINISTRATOR: Edit/Read access to local data and admin rights', 3, 0, NULL, 'vhamocryank', 'vhamocryank',  GETDATE(), GETDATE(), NULL, 6, 0);

-- MSSR_LOCAL
INSERT INTO [V5_Registry].[dbo].[STD_ROLE] (ID, CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, INACTIVE_FLAG, INACTIVE_DATE, CREATEDBY, UPDATEDBY, CREATED, UPDATED, PARENT_ROLE_ID, STD_REGISTRY_ID, SUPER_USER_FLAG)
VALUES (410, 'MSSR_LOCAL', 'MSSR LOCAL', 'MSSR LOCAL: Edit/Read access to local data only', 4, 0, NULL, 'vhamocryank', 'vhamocryank',  GETDATE(), GETDATE(), NULL, 6, 0);

-- MSSR_NATIONAL_READONLY
INSERT INTO [V5_Registry].[dbo].[STD_ROLE] (ID, CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, INACTIVE_FLAG, INACTIVE_DATE, CREATEDBY, UPDATEDBY, CREATED, UPDATED, PARENT_ROLE_ID, STD_REGISTRY_ID, SUPER_USER_FLAG)
VALUES (411, 'MSSR_NATIONAL_READONLY', 'MSSR NATIONAL READONLY', 'MSSR NATIONAL READONLY: No transaction ability, just viewing  but national level', 5, 0, NULL, 'vhamocryank', 'vhamocryank',  GETDATE(), GETDATE(), NULL, 6, 0);

-- MSSR_LOCAL_READONLY
INSERT INTO [V5_Registry].[dbo].[STD_ROLE] (ID, CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, INACTIVE_FLAG, INACTIVE_DATE, CREATEDBY, UPDATEDBY, CREATED, UPDATED, PARENT_ROLE_ID, STD_REGISTRY_ID, SUPER_USER_FLAG)
VALUES (412, 'MSSR_LOCAL_READONLY', 'MSSR LOCAL READONLY', 'MSSR LOCAL READONLY: No transaction ability, just viewing  but local level', 6, 0, NULL, 'vhamocryank', 'vhamocryank',  GETDATE(), GETDATE(), NULL, 6, 0);

SET IDENTITY_INSERT [dbo].[STD_ROLE] OFF

END
GO


/*********************************************************************
* ASSIGN USER TO REGISTRY
*********************************************************************/
IF (SELECT COUNT(*) FROM [dbo].[USER_REGISTRIES] WHERE [STD_REGISTRY_ID] = 6) > 0
BEGIN

INSERT INTO [V5_Registry].[dbo].[USER_REGISTRIES]([STD_REGISTRY_ID],[USER_ID],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED])
VALUES(6,190,'PII', GETDATE(), 'PII', GETDATE());

END
GO

/*********************************************************************
* ASSIGN USER TO ROLE
*********************************************************************/
IF (SELECT COUNT(*) FROM [dbo].[STD_ROLE] WHERE [ID] = 407) > 0
BEGIN

INSERT INTO [dbo].[USER_ROLES] ([USER_ID],[STD_ROLE_ID],[STD_INSTITUTION_ID],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED]) 
VALUES(190, 407, 1000001, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());

END
GO

/*********************************************************************
* ADD ALL PAGES TO STD_APPPAGE TABLE FOR REGISTRY
*********************************************************************/
IF (SELECT COUNT(*) FROM [dbo].[STD_APPPAGE] WHERE [ID] > 112 AND [ID] < 121) = 0
BEGIN

SET IDENTITY_INSERT [dbo].[STD_APPPAGE] ON

--MSSR ADMIN EDIT USERS
INSERT INTO [dbo].[STD_APPPAGE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES(113, 'MSSR ADMIN EDIT USERS', 'MSSR ADMIN EDIT USERS', 'MSSR ADMIN EDIT USERS', 1, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());
--MSSR ADMIN LIST USERS
INSERT INTO [dbo].[STD_APPPAGE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES(114,'MSSR ADMIN LIST USERS', 'MSSR ADMIN LIST USERS', 'MSSR ADMIN LIST USERS', 1, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());
--MSSR PATIENTS
INSERT INTO [dbo].[STD_APPPAGE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES(115,'MSSR PATIENTS', 'MSSR PATIENTS', 'MSSR PATIENTS', 1, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());
--MSSR DEFAULT
INSERT INTO [dbo].[STD_APPPAGE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES(116,'MSSR DEFAULT', 'MSSR DEFAULT', 'MSSR DEFAULT', 1, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());
--MSSR DEFAULT
INSERT INTO [dbo].[STD_APPPAGE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES(117,'MSSR DEFAULT REPORTING', 'MSSR DEFAULT REPORTING', 'MSSR DEFAULT REPORTING', 1, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());
INSERT INTO [dbo].[STD_APPPAGE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES(118,'MSSR ADMIN USER ROLE', 'MSSR ADMIN USER ROLE', 'MSSR ADMIN USER ROLE', 1, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());
INSERT INTO [dbo].[STD_APPPAGE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES(119,'MSSR SYSTEM AVAILABILITY', 'MSSR SYSTEM AVAILABILITY', 'MSSR SYSTEM AVAILABILITY', 1, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());
INSERT INTO [dbo].[STD_APPPAGE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES(120,'MSSR CUSTOM REPORTING', 'MSSR CUSTOM REPORTING', 'MSSR CUSTOM REPORTING', 1, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());

-- Admin only for test data creation
INSERT INTO [dbo].[STD_APPPAGE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES(121,'MSSR TEST DATA CREATION', 'MSSR TEST DATA CREATION', 'MSSR TEST DATA CREATION', 1, 0, NULL, 'PII', 'PII', GETDATE(), GETDATE());

SET IDENTITY_INSERT [dbo].[STD_APPPAGE] OFF

END
GO

/*********************************************************************
* ADD ROLE TO PAGE RELATIONSHIP
*********************************************************************/
IF (SELECT COUNT(*) FROM [dbo].[ROLE_PERMISSIONS] WHERE [STD_ROLE_ID] = 407 AND [STD_APPPAGE_ID] = 113) = 0
BEGIN

-- 407: MSSR_SYSTEM_ADMINISTRATOR / MSSR EDIT USERS (113)
INSERT INTO [V5_Registry].[dbo].[ROLE_PERMISSIONS]([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
VALUES(407, 113, 'PII', 'PII', GETDATE(), GETDATE(), 1, 0, 0);

-- 407: MSSR_SYSTEM_ADMINISTRATOR / MSSR ADMIN LIST USERS (114)
INSERT INTO [V5_Registry].[dbo].[ROLE_PERMISSIONS]([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
VALUES(407, 114, 'PII', 'PII', GETDATE(), GETDATE(), 1, 0, 0);

-- 407: MSSR_SYSTEM_ADMINISTRATOR / MSSR PATIENTS (115)
INSERT INTO [V5_Registry].[dbo].[ROLE_PERMISSIONS]([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
VALUES(407, 115, 'PII', 'PII', GETDATE(), GETDATE(), 1, 0, 0);

-- 407: MSSR_SYSTEM_ADMINISTRATOR / MSSR DEFAULT (116)
INSERT INTO [V5_Registry].[dbo].[ROLE_PERMISSIONS]([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
VALUES(407, 116, 'PII', 'PII', GETDATE(), GETDATE(), 1, 0, 0);

-- 407: MSSR_SYSTEM_ADMINISTRATOR / MSSR DEFAULT REPORTING (117)
INSERT INTO [V5_Registry].[dbo].[ROLE_PERMISSIONS]([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
VALUES(407, 117, 'PII', 'PII', GETDATE(), GETDATE(), 1, 0, 0);

-- 407: MSSR_SYSTEM_ADMINISTRATOR / MSSR ADMIN USER ROLE (118)
INSERT INTO [V5_Registry].[dbo].[ROLE_PERMISSIONS]([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
VALUES(407, 118, 'PII', 'PII', GETDATE(), GETDATE(), 1, 0, 0);

-- 407: MSSR_SYSTEM_ADMINISTRATOR / MSSR SYSTEM AVAILABILITY (119)
INSERT INTO [V5_Registry].[dbo].[ROLE_PERMISSIONS]([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
VALUES(407, 119, 'PII', 'PII', GETDATE(), GETDATE(), 1, 0, 0);

-- 407: MSSR_SYSTEM_ADMINISTRATOR / MSSR CUSTOM REPORTING (120)
INSERT INTO [V5_Registry].[dbo].[ROLE_PERMISSIONS]([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
VALUES(407, 120, 'PII', 'PII', GETDATE(), GETDATE(), 1, 0, 0);

-- 407: MSSR_SYSTEM_ADMINISTRATOR / MSSR TEST DATA CREATION(121)
INSERT INTO [V5_Registry].[dbo].[ROLE_PERMISSIONS]([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
VALUES(407, 121, 'PII', 'PII', GETDATE(), GETDATE(), 1, 0, 0);

END
GO